/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.redis.clients.jedis;

import net.impactdev.impactor.relocations.org.apache.commons.pool2.PooledObject;
import net.impactdev.impactor.relocations.org.apache.commons.pool2.PooledObjectFactory;
import net.impactdev.impactor.relocations.org.apache.commons.pool2.impl.DefaultPooledObject;
import net.impactdev.impactor.relocations.redis.clients.jedis.Connection;
import net.impactdev.impactor.relocations.redis.clients.jedis.DefaultJedisClientConfig;
import net.impactdev.impactor.relocations.redis.clients.jedis.DefaultJedisSocketFactory;
import net.impactdev.impactor.relocations.redis.clients.jedis.HostAndPort;
import net.impactdev.impactor.relocations.redis.clients.jedis.JedisClientConfig;
import net.impactdev.impactor.relocations.redis.clients.jedis.JedisSocketFactory;
import net.impactdev.impactor.relocations.redis.clients.jedis.exceptions.JedisException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionFactory
implements PooledObjectFactory<Connection> {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionFactory.class);
    private final JedisSocketFactory jedisSocketFactory;
    private final JedisClientConfig clientConfig;

    public ConnectionFactory(HostAndPort hostAndPort) {
        this.clientConfig = DefaultJedisClientConfig.builder().build();
        this.jedisSocketFactory = new DefaultJedisSocketFactory(hostAndPort);
    }

    public ConnectionFactory(HostAndPort hostAndPort, JedisClientConfig clientConfig) {
        this.clientConfig = DefaultJedisClientConfig.copyConfig(clientConfig);
        this.jedisSocketFactory = new DefaultJedisSocketFactory(hostAndPort, this.clientConfig);
    }

    public ConnectionFactory(JedisSocketFactory jedisSocketFactory, JedisClientConfig clientConfig) {
        this.clientConfig = DefaultJedisClientConfig.copyConfig(clientConfig);
        this.jedisSocketFactory = jedisSocketFactory;
    }

    @Override
    public void activateObject(PooledObject<Connection> pooledConnection) throws Exception {
    }

    @Override
    public void destroyObject(PooledObject<Connection> pooledConnection) throws Exception {
        Connection jedis = pooledConnection.getObject();
        if (jedis.isConnected()) {
            try {
                jedis.close();
            }
            catch (RuntimeException e) {
                logger.debug("Error while close", (Throwable)e);
            }
        }
    }

    @Override
    public PooledObject<Connection> makeObject() throws Exception {
        Connection jedis = null;
        try {
            jedis = new Connection(this.jedisSocketFactory, this.clientConfig);
            return new DefaultPooledObject<Connection>(jedis);
        }
        catch (JedisException je) {
            logger.debug("Error while makeObject", (Throwable)je);
            throw je;
        }
    }

    @Override
    public void passivateObject(PooledObject<Connection> pooledConnection) throws Exception {
    }

    @Override
    public boolean validateObject(PooledObject<Connection> pooledConnection) {
        Connection jedis = pooledConnection.getObject();
        try {
            return jedis.isConnected() && jedis.ping();
        }
        catch (Exception e) {
            logger.error("Error while validating pooled Connection object.", (Throwable)e);
            return false;
        }
    }
}

